//var MbObject = function(data){
//    this.sourceData = data;
//}
//
//MbObject.prototype = {
//    getX: function(){
//        return this.sourceData['-x'];
//    }
//}

var MbFrame = function(data){
    this.sourceData = data;
    this.Activity = null;
}

//MbFrame.prototype = new MbObject();
//MbFrame.prototype.constructor = MbFrame;

MbFrame.prototype = {
    getX: function(){
        return this.sourceData['-x'];
    }
    ,getY: function(){
        return this.sourceData['-y'];
    }
    ,getWidth: function(){
        return this.sourceData['-width'];
    }
    ,getHeight: function(){
        return this.sourceData['-height'];
    }
    ,getColor: function(){
        return '#' + this.sourceData['-color'].substr(2);
    }
    ,getId: function(){
        return this.sourceData['-id'];
    }
    ,getActivity: function(){
        return this.Activity;
    }

    ,setActivity: function(MbActivity){
        this.Activity = MbActivity;
    }
}


/**
 *
 * @param data
 * @constructor
 */
var MbIcon = function(data){
    this.sourceData = data;
    this.activities = [];
}

MbIcon.prototype = {
    getId: function(){
        return this.sourceData['-id'];
    }

    ,addActivity: function(Activity){
        this.activities.push(Activity);
    }

    ,getActivities: function(){
        return this.activities;
    }
}


var MbContent = function(data){
    this.sourceData = data;
    this.activities = [];
}

MbContent.prototype = {
    getId: function(){
        return this.sourceData['-id'];
    }
    ,addActivity: function(Activity){
        this.activities.push(Activity);
    }

    ,getPath: function(){
        return this.sourceData['-path'];
    }
    ,getTitle: function(){
        return this.sourceData['Title'];
    }
    ,getType: function(){
        return this.sourceData['-type'];
    }

    ,getActivities: function(){
        return this.activities;
    }

}




/**
 *
 * @param data
 * @constructor
 */
var MbActivity = function(data){
    this.sourceData = data;
    this.frames = [];
    this.contents = [];
    this.icon = null;

    this.colors = {
        _link: '#AABBCC'
        ,_movie: '#EEFF11'
        ,_richText: '#FFAA33'
        ,_plink: '#CCAACC'
        ,_simpleSound: '#DD1100'
        ,_flash: '#AA00BB'
    }
}

MbActivity.prototype = {
    addContent: function(Content){
        this.contents.push(Content);
    }
    ,addFrame: function(MbFrame){
        this.frames.push(MbFrame);
    }
    ,getContents: function(){
        return this.contents;
    }
    ,getFrames: function(){
        return this.frames;
    }
    ,getColor: function(){
        if(typeof this.colors[this.getType()] != 'undefined')
        {
            return this.colors[this.getType()];
        }
        else
        {
//            console.log('No colors for type: ' + this.getType())
            return '#FF0000';
        }
    }
    ,getIcon: function(){
        return this.icon;
    }
    ,getId: function(){
        return this.sourceData['-id'];
    }
    ,getType: function(){
        return this.sourceData['-type'];
    }
    ,setIcon: function(Icon){
        this.icon = Icon;
    }
}
